/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.h14199.command.Parser;
import org.h14199.command.dml.AllColumnsForPlan;
import org.h14199.command.dml.Select;
import org.h14199.engine.Session;
import org.h14199.expression.Expression;
import org.h14199.expression.ExpressionColumn;
import org.h14199.expression.condition.ConditionAndOr;
import org.h14199.index.Index;
import org.h14199.index.IndexCondition;
import org.h14199.index.IndexCursor;
import org.h14199.index.IndexLookupBatch;
import org.h14199.index.ViewIndex;
import org.h14199.message.DbException;
import org.h14199.result.Row;
import org.h14199.result.SearchRow;
import org.h14199.result.SortOrder;
import org.h14199.table.Column;
import org.h14199.table.ColumnResolver;
import org.h14199.table.IndexHints;
import org.h14199.table.JoinBatch;
import org.h14199.table.PlanItem;
import org.h14199.table.SubQueryInfo;
import org.h14199.table.Table;
import org.h14199.table.TableView;
import org.h14199.util.StringUtils;
import org.h14199.util.Utils;
import org.h14199.value.Value;
import org.h14199.value.ValueLong;
import org.h14199.value.ValueNull;

public class TableFilter
implements ColumnResolver {
    private static final int BEFORE_FIRST = 0;
    private static final int FOUND = 1;
    private static final int AFTER_LAST = 2;
    private static final int NULL_ROW = 3;
    protected boolean joinOuterIndirect;
    private Session session;
    private final Table table;
    private final Select select;
    private String alias;
    private Index index;
    private final IndexHints indexHints;
    private int[] masks;
    private int scanCount;
    private boolean evaluatable;
    private JoinBatch joinBatch;
    private int joinFilterId = -1;
    private boolean used;
    private final IndexCursor cursor;
    private final ArrayList<IndexCondition> indexConditions = Utils.newSmallArrayList();
    private boolean doneWithIndexConditions;
    private Expression filterCondition;
    private Expression joinCondition;
    private SearchRow currentSearchRow;
    private Row current;
    private int state;
    private TableFilter join;
    private boolean joinOuter;
    private TableFilter nestedJoin;
    private ArrayList<Column> naturalJoinColumns;
    private boolean foundOne;
    private Expression fullCondition;
    private final int hashCode;
    private final int orderInFrom;
    private LinkedHashMap<Column, String> derivedColumnMap;

    public TableFilter(Session session, Table table, String string, boolean bl, Select select, int n, IndexHints indexHints) {
        this.session = session;
        this.table = table;
        this.alias = string;
        this.select = select;
        this.cursor = new IndexCursor(this);
        if (!bl) {
            session.getUser().checkRight(table, 1);
        }
        this.hashCode = session.nextObjectId();
        this.orderInFrom = n;
        this.indexHints = indexHints;
    }

    public int getOrderInFrom() {
        return this.orderInFrom;
    }

    public IndexCursor getIndexCursor() {
        return this.cursor;
    }

    @Override
    public Select getSelect() {
        return this.select;
    }

    public Table getTable() {
        return this.table;
    }

    public void lock(Session session, boolean bl, boolean bl2) {
        this.table.lock(session, bl, bl2);
        if (this.join != null) {
            this.join.lock(session, bl, bl2);
        }
    }

    public PlanItem getBestPlanItem(Session session, TableFilter[] tableFilterArray, int n, AllColumnsForPlan allColumnsForPlan) {
        PlanItem planItem = null;
        SortOrder sortOrder = null;
        if (this.select != null) {
            sortOrder = this.select.getSortOrder();
        }
        if (this.indexConditions.isEmpty()) {
            planItem = new PlanItem();
            planItem.setIndex(this.table.getScanIndex(session, null, tableFilterArray, n, sortOrder, allColumnsForPlan));
            planItem.cost = planItem.getIndex().getCost(session, null, tableFilterArray, n, sortOrder, allColumnsForPlan);
        }
        int n2 = this.table.getColumns().length;
        int[] nArray = new int[n2];
        for (IndexCondition indexCondition : this.indexConditions) {
            if (!indexCondition.isEvaluatable()) continue;
            if (indexCondition.isAlwaysFalse()) {
                nArray = null;
                break;
            }
            int n3 = indexCondition.getColumn().getColumnId();
            if (n3 < 0) continue;
            int n4 = n3;
            nArray[n4] = nArray[n4] | indexCondition.getMask(this.indexConditions);
        }
        Object object = this.table.getBestPlanItem(session, nArray, tableFilterArray, n, sortOrder, allColumnsForPlan);
        ((PlanItem)object).setMasks(nArray);
        ((PlanItem)object).cost -= ((PlanItem)object).cost * (double)this.indexConditions.size() / 100.0 / (double)(n + 1);
        if (planItem != null && planItem.cost < ((PlanItem)object).cost) {
            object = planItem;
        }
        if (this.nestedJoin != null) {
            this.setEvaluatable(true);
            ((PlanItem)object).setNestedJoinPlan(this.nestedJoin.getBestPlanItem(session, tableFilterArray, n, allColumnsForPlan));
            ((PlanItem)object).cost += ((PlanItem)object).cost * ((PlanItem)object).getNestedJoinPlan().cost;
        }
        if (this.join != null) {
            this.setEvaluatable(true);
            while (tableFilterArray[++n] != this.join) {
            }
            ((PlanItem)object).setJoinPlan(this.join.getBestPlanItem(session, tableFilterArray, n, allColumnsForPlan));
            ((PlanItem)object).cost += ((PlanItem)object).cost * ((PlanItem)object).getJoinPlan().cost;
        }
        return object;
    }

    public void setPlanItem(PlanItem planItem) {
        if (planItem == null) {
            return;
        }
        this.setIndex(planItem.getIndex());
        this.masks = planItem.getMasks();
        if (this.nestedJoin != null) {
            if (planItem.getNestedJoinPlan() != null) {
                this.nestedJoin.setPlanItem(planItem.getNestedJoinPlan());
            } else {
                this.nestedJoin.setScanIndexes();
            }
        }
        if (this.join != null) {
            if (planItem.getJoinPlan() != null) {
                this.join.setPlanItem(planItem.getJoinPlan());
            } else {
                this.join.setScanIndexes();
            }
        }
    }

    private void setScanIndexes() {
        if (this.index == null) {
            this.setIndex(this.table.getScanIndex(this.session));
        }
        if (this.join != null) {
            this.join.setScanIndexes();
        }
        if (this.nestedJoin != null) {
            this.nestedJoin.setScanIndexes();
        }
    }

    public void prepare() {
        for (int i = 0; i < this.indexConditions.size(); ++i) {
            Column column;
            IndexCondition indexCondition = this.indexConditions.get(i);
            if (indexCondition.isAlwaysFalse() || (column = indexCondition.getColumn()).getColumnId() < 0 || this.index.getColumnIndex(column) >= 0) continue;
            this.indexConditions.remove(i);
            --i;
        }
        if (this.nestedJoin != null) {
            if (this.nestedJoin == this) {
                DbException.throwInternalError("self join");
            }
            this.nestedJoin.prepare();
        }
        if (this.join != null) {
            if (this.join == this) {
                DbException.throwInternalError("self join");
            }
            this.join.prepare();
        }
        if (this.filterCondition != null) {
            this.filterCondition = this.filterCondition.optimize(this.session);
        }
        if (this.joinCondition != null) {
            this.joinCondition = this.joinCondition.optimize(this.session);
        }
    }

    public void startQuery(Session session) {
        this.session = session;
        this.scanCount = 0;
        if (this.nestedJoin != null) {
            this.nestedJoin.startQuery(session);
        }
        if (this.join != null) {
            this.join.startQuery(session);
        }
    }

    public void reset() {
        if (this.joinBatch != null && this.joinFilterId == 0) {
            this.joinBatch.reset(true);
            return;
        }
        if (this.nestedJoin != null) {
            this.nestedJoin.reset();
        }
        if (this.join != null) {
            this.join.reset();
        }
        this.state = 0;
        this.foundOne = false;
    }

    private boolean isAlwaysTopTableFilter(int n) {
        if (n != 0) {
            return false;
        }
        SubQueryInfo subQueryInfo = this.session.getSubQueryInfo();
        while (subQueryInfo != null) {
            if (subQueryInfo.getFilter() != 0) {
                return false;
            }
            subQueryInfo = subQueryInfo.getUpper();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JoinBatch prepareJoinBatch(JoinBatch joinBatch, TableFilter[] tableFilterArray, int n) {
        assert (tableFilterArray[n] == this);
        this.joinBatch = null;
        this.joinFilterId = -1;
        if (this.getTable().isView()) {
            this.session.pushSubQueryInfo(this.masks, tableFilterArray, n, this.select.getSortOrder());
            try {
                ((ViewIndex)this.index).getQuery().prepareJoinBatch();
            }
            finally {
                this.session.popSubQueryInfo();
            }
        }
        IndexLookupBatch indexLookupBatch = null;
        if (joinBatch == null && this.select != null && !this.isAlwaysTopTableFilter(n) && (indexLookupBatch = this.index.createLookupBatch(tableFilterArray, n)) != null) {
            joinBatch = new JoinBatch(n + 1, this.join);
        }
        if (joinBatch != null) {
            if (this.nestedJoin != null) {
                throw DbException.throwInternalError();
            }
            this.joinBatch = joinBatch;
            this.joinFilterId = n;
            if (indexLookupBatch == null && !this.isAlwaysTopTableFilter(n) && (indexLookupBatch = this.index.createLookupBatch(tableFilterArray, n)) == null) {
                indexLookupBatch = JoinBatch.createFakeIndexLookupBatch(this);
            }
            joinBatch.register(this, indexLookupBatch);
        }
        return joinBatch;
    }

    public int getJoinFilterId() {
        return this.joinFilterId;
    }

    public JoinBatch getJoinBatch() {
        return this.joinBatch;
    }

    public boolean next() {
        if (this.joinBatch != null) {
            return this.joinBatch.next();
        }
        if (this.state == 2) {
            return false;
        }
        if (this.state == 0) {
            this.cursor.find(this.session, this.indexConditions);
            if (!this.cursor.isAlwaysFalse()) {
                if (this.nestedJoin != null) {
                    this.nestedJoin.reset();
                }
                if (this.join != null) {
                    this.join.reset();
                }
            }
        } else if (this.join != null && this.join.next()) {
            return true;
        }
        while (this.state != 3) {
            if (this.cursor.isAlwaysFalse()) {
                this.state = 2;
            } else if (this.nestedJoin != null) {
                if (this.state == 0) {
                    this.state = 1;
                }
            } else {
                if ((++this.scanCount & 0xFFF) == 0) {
                    this.checkTimeout();
                }
                if (this.cursor.next()) {
                    this.currentSearchRow = this.cursor.getSearchRow();
                    this.current = null;
                    this.state = 1;
                } else {
                    this.state = 2;
                }
            }
            if (this.nestedJoin != null && this.state == 1 && !this.nestedJoin.next()) {
                this.state = 2;
                if (!this.joinOuter || this.foundOne) continue;
            }
            if (this.state == 2) {
                if (!this.joinOuter || this.foundOne) break;
                this.setNullRow();
            }
            if (!this.isOk(this.filterCondition)) continue;
            boolean bl = this.isOk(this.joinCondition);
            if (this.state == 1) {
                if (!bl) continue;
                this.foundOne = true;
            }
            if (this.join != null) {
                this.join.reset();
                if (!this.join.next()) continue;
            }
            if (this.state != 3 && !bl) continue;
            return true;
        }
        this.state = 2;
        return false;
    }

    protected void setNullRow() {
        this.state = 3;
        this.current = this.table.getNullRow();
        this.currentSearchRow = this.current;
        if (this.nestedJoin != null) {
            this.nestedJoin.visit(new TableFilterVisitor(){

                @Override
                public void accept(TableFilter tableFilter) {
                    tableFilter.setNullRow();
                }
            });
        }
    }

    private void checkTimeout() {
        this.session.checkCanceled();
    }

    boolean isOk(Expression expression) {
        return expression == null || expression.getBooleanValue(this.session);
    }

    public Row get() {
        if (this.current == null && this.currentSearchRow != null) {
            this.current = this.cursor.get();
        }
        return this.current;
    }

    public void set(Row row) {
        this.current = row;
        this.currentSearchRow = row;
    }

    @Override
    public String getTableAlias() {
        if (this.alias != null) {
            return this.alias;
        }
        return this.table.getName();
    }

    public void addIndexCondition(IndexCondition indexCondition) {
        if (!this.doneWithIndexConditions) {
            this.indexConditions.add(indexCondition);
        }
    }

    public void doneWithIndexConditions() {
        this.doneWithIndexConditions = true;
    }

    public void addFilterCondition(Expression expression, boolean bl) {
        if (bl) {
            this.joinCondition = this.joinCondition == null ? expression : new ConditionAndOr(0, this.joinCondition, expression);
        } else {
            this.filterCondition = this.filterCondition == null ? expression : new ConditionAndOr(0, this.filterCondition, expression);
        }
    }

    public void addJoin(TableFilter tableFilter, boolean bl, Expression expression) {
        if (expression != null) {
            expression.mapColumns(this, 0, 0);
            MapColumnsVisitor mapColumnsVisitor = new MapColumnsVisitor(expression);
            this.visit(mapColumnsVisitor);
            tableFilter.visit(mapColumnsVisitor);
        }
        if (this.join == null) {
            this.join = tableFilter;
            tableFilter.joinOuter = bl;
            if (bl) {
                tableFilter.visit(new JOIVisitor());
            }
            if (expression != null) {
                tableFilter.mapAndAddFilter(expression);
            }
        } else {
            this.join.addJoin(tableFilter, bl, expression);
        }
    }

    public void setNestedJoin(TableFilter tableFilter) {
        this.nestedJoin = tableFilter;
    }

    public void mapAndAddFilter(Expression expression) {
        expression.mapColumns(this, 0, 0);
        this.addFilterCondition(expression, true);
        if (this.nestedJoin != null) {
            expression.mapColumns(this.nestedJoin, 0, 0);
        }
        if (this.join != null) {
            this.join.mapAndAddFilter(expression);
        }
    }

    public void createIndexConditions() {
        if (this.joinCondition != null) {
            this.joinCondition = this.joinCondition.optimize(this.session);
            this.joinCondition.createIndexConditions(this.session, this);
            if (this.nestedJoin != null) {
                this.joinCondition.createIndexConditions(this.session, this.nestedJoin);
            }
        }
        if (this.join != null) {
            this.join.createIndexConditions();
        }
        if (this.nestedJoin != null) {
            this.nestedJoin.createIndexConditions();
        }
    }

    public TableFilter getJoin() {
        return this.join;
    }

    public boolean isJoinOuter() {
        return this.joinOuter;
    }

    public boolean isJoinOuterIndirect() {
        return this.joinOuterIndirect;
    }

    public StringBuilder getPlanSQL(StringBuilder stringBuilder, boolean bl, boolean bl2) {
        boolean bl3;
        if (bl) {
            if (this.joinOuter) {
                stringBuilder.append("LEFT OUTER JOIN ");
            } else {
                stringBuilder.append("INNER JOIN ");
            }
        }
        if (this.nestedJoin != null) {
            boolean bl4;
            StringBuilder stringBuilder2 = new StringBuilder();
            TableFilter tableFilter = this.nestedJoin;
            do {
                tableFilter.getPlanSQL(stringBuilder2, tableFilter != this.nestedJoin, bl2).append('\n');
            } while ((tableFilter = tableFilter.getJoin()) != null);
            String string = stringBuilder2.toString();
            boolean bl5 = bl4 = !string.startsWith("(");
            if (bl4) {
                stringBuilder.append("(\n");
            }
            StringUtils.indent(stringBuilder, string, 4, false);
            if (bl4) {
                stringBuilder.append(')');
            }
            if (bl) {
                stringBuilder.append(" ON ");
                if (this.joinCondition == null) {
                    stringBuilder.append("1=1");
                } else {
                    this.joinCondition.getUnenclosedSQL(stringBuilder, bl2);
                }
            }
            return stringBuilder;
        }
        if (this.table.isView() && ((TableView)this.table).isRecursive()) {
            this.table.getSchema().getSQL(stringBuilder, bl2).append('.');
            Parser.quoteIdentifier(stringBuilder, this.table.getName(), bl2);
        } else {
            this.table.getSQL(stringBuilder, bl2);
        }
        if (this.table.isView() && ((TableView)this.table).isInvalid()) {
            throw DbException.get(90109, this.table.getName(), "not compiled");
        }
        if (this.alias != null) {
            stringBuilder.append(' ');
            Parser.quoteIdentifier(stringBuilder, this.alias, bl2);
            if (this.derivedColumnMap != null) {
                stringBuilder.append('(');
                bl3 = false;
                for (String string : this.derivedColumnMap.values()) {
                    if (bl3) {
                        stringBuilder.append(", ");
                    }
                    bl3 = true;
                    Parser.quoteIdentifier(stringBuilder, string, bl2);
                }
                stringBuilder.append(')');
            }
        }
        if (this.indexHints != null) {
            stringBuilder.append(" USE INDEX (");
            bl3 = true;
            for (String string : this.indexHints.getAllowedIndexes()) {
                if (!bl3) {
                    stringBuilder.append(", ");
                } else {
                    bl3 = false;
                }
                Parser.quoteIdentifier(stringBuilder, string, bl2);
            }
            stringBuilder.append(")");
        }
        if (this.index != null) {
            stringBuilder.append('\n');
            StringBuilder stringBuilder3 = new StringBuilder();
            if (this.joinBatch != null) {
                IndexLookupBatch indexLookupBatch = this.joinBatch.getLookupBatch(this.joinFilterId);
                if (indexLookupBatch == null) {
                    if (this.joinFilterId != 0) {
                        throw DbException.throwInternalError(Integer.toString(this.joinFilterId));
                    }
                } else {
                    stringBuilder3.append("batched:").append(indexLookupBatch.getPlanSQL()).append(' ');
                }
            }
            stringBuilder3.append(this.index.getPlanSQL());
            if (!this.indexConditions.isEmpty()) {
                stringBuilder3.append(": ");
                int n = this.indexConditions.size();
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        stringBuilder3.append("\n    AND ");
                    }
                    stringBuilder3.append(this.indexConditions.get(i).getSQL(false));
                }
            }
            String string = StringUtils.quoteRemarkSQL(stringBuilder3.toString());
            stringBuilder3.setLength(0);
            stringBuilder3.append("/* ").append(string);
            if (string.indexOf(10) >= 0) {
                stringBuilder3.append('\n');
            }
            StringUtils.indent(stringBuilder, stringBuilder3.append(" */").toString(), 4, false);
        }
        if (bl) {
            stringBuilder.append("\n    ON ");
            if (this.joinCondition == null) {
                stringBuilder.append("1=1");
            } else {
                this.joinCondition.getUnenclosedSQL(stringBuilder, bl2);
            }
        }
        if (this.filterCondition != null) {
            stringBuilder.append('\n');
            Object object = StringUtils.unEnclose(this.filterCondition.getSQL(false));
            object = "/* WHERE " + StringUtils.quoteRemarkSQL((String)object) + "\n*/";
            StringUtils.indent(stringBuilder, (String)object, 4, false);
        }
        if (this.scanCount > 0) {
            stringBuilder.append("\n    /* scanCount: ").append(this.scanCount).append(" */");
        }
        return stringBuilder;
    }

    void removeUnusableIndexConditions() {
        for (int i = 0; i < this.indexConditions.size(); ++i) {
            IndexCondition indexCondition = this.indexConditions.get(i);
            if (indexCondition.isEvaluatable()) continue;
            this.indexConditions.remove(i--);
        }
    }

    public int[] getMasks() {
        return this.masks;
    }

    public ArrayList<IndexCondition> getIndexConditions() {
        return this.indexConditions;
    }

    public Index getIndex() {
        return this.index;
    }

    public void setIndex(Index index) {
        this.index = index;
        this.cursor.setIndex(index);
    }

    public void setUsed(boolean bl) {
        this.used = bl;
    }

    public boolean isUsed() {
        return this.used;
    }

    void setSession(Session session) {
        this.session = session;
    }

    public void removeJoin() {
        this.join = null;
    }

    public Expression getJoinCondition() {
        return this.joinCondition;
    }

    public void removeJoinCondition() {
        this.joinCondition = null;
    }

    public Expression getFilterCondition() {
        return this.filterCondition;
    }

    public void removeFilterCondition() {
        this.filterCondition = null;
    }

    public void setFullCondition(Expression expression) {
        this.fullCondition = expression;
        if (this.join != null) {
            this.join.setFullCondition(expression);
        }
    }

    void optimizeFullCondition(boolean bl) {
        if (this.fullCondition != null) {
            this.fullCondition.addFilterConditions(this, bl || this.joinOuter);
            if (this.nestedJoin != null) {
                this.nestedJoin.optimizeFullCondition(bl || this.joinOuter);
            }
            if (this.join != null) {
                this.join.optimizeFullCondition(bl || this.joinOuter);
            }
        }
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        tableFilter.setEvaluatable(bl);
        if (this.filterCondition != null) {
            this.filterCondition.setEvaluatable(tableFilter, bl);
        }
        if (this.joinCondition != null) {
            this.joinCondition.setEvaluatable(tableFilter, bl);
        }
        if (this.nestedJoin != null && this == tableFilter) {
            this.nestedJoin.setEvaluatable(this.nestedJoin, bl);
        }
        if (this.join != null) {
            this.join.setEvaluatable(tableFilter, bl);
        }
    }

    public void setEvaluatable(boolean bl) {
        this.evaluatable = bl;
    }

    @Override
    public String getSchemaName() {
        return this.table.getSchema().getName();
    }

    @Override
    public Column[] getColumns() {
        return this.table.getColumns();
    }

    @Override
    public String getDerivedColumnName(Column column) {
        LinkedHashMap<Column, String> linkedHashMap = this.derivedColumnMap;
        return linkedHashMap != null ? (String)((HashMap)linkedHashMap).get(column) : null;
    }

    @Override
    public Column[] getSystemColumns() {
        if (!this.session.getDatabase().getMode().systemColumns) {
            return null;
        }
        Column[] columnArray = new Column[3];
        columnArray[0] = new Column("oid", 4);
        columnArray[0].setTable(this.table, 0);
        columnArray[1] = new Column("ctid", 13);
        columnArray[1].setTable(this.table, 0);
        columnArray[2] = new Column("CTID", 13);
        columnArray[2].setTable(this.table, 0);
        return columnArray;
    }

    @Override
    public Column getRowIdColumn() {
        return this.table.getRowIdColumn();
    }

    @Override
    public Value getValue(Column column) {
        if (this.joinBatch != null) {
            return this.joinBatch.getValue(this.joinFilterId, column);
        }
        if (this.currentSearchRow == null) {
            return null;
        }
        int n = column.getColumnId();
        if (n == -1) {
            return ValueLong.get(this.currentSearchRow.getKey());
        }
        if (this.current == null) {
            Value value = this.currentSearchRow.getValue(n);
            if (value != null) {
                return value;
            }
            this.current = this.cursor.get();
            if (this.current == null) {
                return ValueNull.INSTANCE;
            }
        }
        return this.current.getValue(n);
    }

    @Override
    public TableFilter getTableFilter() {
        return this;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public void setDerivedColumns(ArrayList<String> arrayList) {
        Column[] columnArray = this.getColumns();
        int n = columnArray.length;
        if (n != arrayList.size()) {
            throw DbException.get(21002);
        }
        LinkedHashMap<Column, String> linkedHashMap = new LinkedHashMap<Column, String>();
        for (int i = 0; i < n; ++i) {
            String string = arrayList.get(i);
            for (int j = 0; j < i; ++j) {
                if (!string.equals(arrayList.get(j))) continue;
                throw DbException.get(42121, string);
            }
            linkedHashMap.put(columnArray[i], string);
        }
        this.derivedColumnMap = linkedHashMap;
    }

    @Override
    public Expression optimize(ExpressionColumn expressionColumn, Column column) {
        return expressionColumn;
    }

    public String toString() {
        return this.alias != null ? this.alias : this.table.toString();
    }

    public void addNaturalJoinColumn(Column column) {
        if (this.naturalJoinColumns == null) {
            this.naturalJoinColumns = Utils.newSmallArrayList();
        }
        this.naturalJoinColumns.add(column);
    }

    public boolean isNaturalJoinColumn(Column column) {
        return this.naturalJoinColumns != null && this.naturalJoinColumns.contains(column);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean hasInComparisons() {
        for (IndexCondition indexCondition : this.indexConditions) {
            int n = indexCondition.getCompareType();
            if (n != 10 && n != 9) continue;
            return true;
        }
        return false;
    }

    public void lockRowAdd(ArrayList<Row> arrayList) {
        if (this.state == 1) {
            arrayList.add(this.get());
        }
    }

    public TableFilter getNestedJoin() {
        return this.nestedJoin;
    }

    public void visit(TableFilterVisitor tableFilterVisitor) {
        TableFilter tableFilter = this;
        do {
            tableFilterVisitor.accept(tableFilter);
            TableFilter tableFilter2 = tableFilter.nestedJoin;
            if (tableFilter2 == null) continue;
            tableFilter2.visit(tableFilterVisitor);
        } while ((tableFilter = tableFilter.join) != null);
    }

    public boolean isEvaluatable() {
        return this.evaluatable;
    }

    public Session getSession() {
        return this.session;
    }

    public IndexHints getIndexHints() {
        return this.indexHints;
    }

    private static final class JOIVisitor
    implements TableFilterVisitor {
        JOIVisitor() {
        }

        @Override
        public void accept(TableFilter tableFilter) {
            tableFilter.joinOuterIndirect = true;
        }
    }

    private static final class MapColumnsVisitor
    implements TableFilterVisitor {
        private final Expression on;

        MapColumnsVisitor(Expression expression) {
            this.on = expression;
        }

        @Override
        public void accept(TableFilter tableFilter) {
            this.on.mapColumns(tableFilter, 0, 0);
        }
    }

    public static interface TableFilterVisitor {
        public void accept(TableFilter var1);
    }
}

